/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkTestDataField;
import filenet.vw.toolkit.runtime.property.VWFieldsTableData;
import filenet.vw.toolkit.runtime.property.VWStepTableModelBase;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWFieldDataForTable;
import filenet.vw.toolkit.utils.table.VWFieldNameForTable;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.JLabel;

public class VWStepFieldsTableModel
extends VWStepTableModelBase {
    protected static final int COL_EXPAND = 0;
    protected static final int COL_NAME = 1;
    protected static final int COL_TYPE = 2;
    protected static final int COL_VALUE = 3;
    protected static final int COL_ACCESS_MODE = 4;
    private Vector m_dataFieldNames = new Vector();
    private Vector m_dataFieldMode = new Vector();

    public VWStepFieldsTableModel() {
        this.m_type = new BitSet();
        this.m_type.set(4);
        this.m_type.set(8);
        this.m_type.set(16);
        this.m_type.set(1);
        this.m_type.set(2);
        this.m_type.set(128);
        this.initColumnNames();
    }

    private int findDataFieldInList(String name) {
        int index = -1;
        for (int i = 0; i < this.m_dataFieldNames.size(); ++i) {
            if (VWStringUtils.compare(name, (String)this.m_dataFieldNames.elementAt(i)) != 0) continue;
            index = i;
            break;
        }
        return index;
    }

    protected VWFieldsTableData newDataFieldInstance(VWTrkTestDataField vwDataField) throws Exception {
        VWFieldsTableData datafield = new VWFieldsTableData(vwDataField);
        String name = vwDataField.getName();
        int index = this.findDataFieldInList(name);
        if (index == -1) {
            this.m_dataFieldNames.addElement(vwDataField.getName());
            this.m_dataFieldMode.addElement(new Boolean(false));
        } else {
            datafield.setExpanded((Boolean)this.m_dataFieldMode.elementAt(index));
        }
        return datafield;
    }

    protected void initColumnNames() {
        if (this.m_columnNames == null) {
            this.m_columnNames = new Vector();
        }
        if (this.m_columnNames.size() == 0) {
            this.m_columnNames.addElement("");
            this.m_columnNames.addElement(VWResource.s_name);
            this.m_columnNames.addElement(VWResource.s_type);
            this.m_columnNames.addElement(VWResource.s_value);
        }
    }

    public Object getValueAt(int row, int col) {
        if (!this.isInRange(row, col)) {
            return null;
        }
        boolean count = false;
        boolean bFound = false;
        int fieldIndex = -1;
        int rowIndex = -1;
        int[] index = new int[2];
        bFound = this.rowToFieldIndex(row, index);
        if (bFound) {
            fieldIndex = index[0];
            rowIndex = index[1];
            VWFieldsTableData dataField = (VWFieldsTableData)this.m_data.elementAt(fieldIndex);
            switch (col) {
                case 0: {
                    if (rowIndex == 0 && dataField.isExpandable()) {
                        return new Boolean(dataField.isExpanded());
                    }
                    return "";
                }
                case 2: {
                    if (rowIndex == 0) {
                        int type = dataField.getType();
                        if (dataField.isArray()) {
                            type |= 0x800;
                        }
                        return new Integer(type);
                    }
                    return null;
                }
                case 1: {
                    if (rowIndex == 0) {
                        return new VWFieldNameForTable(dataField.getName(), dataField.getDescription());
                    }
                    return null;
                }
                case 3: {
                    int type = dataField.getType();
                    boolean bArray = dataField.isArray();
                    if (dataField.isVariousValues()) {
                        return new VWFieldDataForTable(type, bArray, dataField.getValue(), dataField.getName());
                    }
                    if (!dataField.isExpandable()) {
                        return new VWFieldDataForTable(type, bArray, dataField.getValue(), dataField.getName());
                    }
                    if (dataField.isExpanded()) {
                        return new VWFieldDataForTable(type, bArray, dataField.getValue(rowIndex), dataField.getName());
                    }
                    if (rowIndex > 0) {
                        return null;
                    }
                    return new VWFieldDataForTable(type, bArray, dataField.getValue(), dataField.getName());
                }
                case 4: {
                    if (rowIndex == 0) {
                        return new Integer(2);
                    }
                    return new JLabel("");
                }
            }
        }
        return null;
    }

    public void setValueAt(Object value, int row, int col) {
        if (!this.isInRange(row, col)) {
            return;
        }
        if (col != 3 && col != 0) {
            return;
        }
        boolean count = false;
        boolean bFound = false;
        int fieldIndex = -1;
        int rowIndex = -1;
        int[] index = new int[2];
        bFound = this.rowToFieldIndex(row, index);
        if (bFound) {
            fieldIndex = index[0];
            rowIndex = index[1];
            VWFieldsTableData dataField = (VWFieldsTableData)this.m_data.elementAt(fieldIndex);
            switch (col) {
                case 0: {
                    if (value == null || !(value instanceof Boolean) || dataField.isExpanded() == ((Boolean)value).booleanValue()) break;
                    dataField.setExpanded((Boolean)value);
                    this.fireTableDataChanged();
                    int indexInList = this.findDataFieldInList(dataField.getName());
                    if (indexInList == -1) break;
                    this.m_dataFieldMode.setElementAt(new Boolean(dataField.isExpanded()), indexInList);
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    try {
                        if (!dataField.isExpandable()) {
                            dataField.setValue(value);
                        } else if (dataField.isExpanded()) {
                            dataField.setValue(value, rowIndex);
                        } else {
                            if (rowIndex != 0) break;
                            dataField.setValue(value);
                        }
                        if (dataField.isExpandable() && dataField.isExpanded()) {
                            this.fireTableRowsUpdated(row, row + dataField.getSize());
                            break;
                        }
                        this.fireTableRowsUpdated(row, row);
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex, VWResource.s_settingFieldValue);
                    }
                    break;
                }
            }
        }
    }

    public Class getColumnClass(int col) {
        if (!this.isColInRange(col)) {
            return null;
        }
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            case 1: 
            case 3: {
                return String.class;
            }
            case 4: {
                return Integer.class;
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        if (!this.isInRange(row, col)) {
            return false;
        }
        switch (col) {
            case 0: {
                int[] index = new int[2];
                boolean bFound = this.rowToFieldIndex(row, index);
                int fieldIndex = index[0];
                int rowIndex = index[1];
                if (bFound) {
                    VWFieldsTableData dataField = (VWFieldsTableData)this.m_data.elementAt(fieldIndex);
                    return dataField.isArray();
                }
                return false;
            }
            case 3: {
                return this.isEditable();
            }
            case 1: 
            case 2: 
            case 4: {
                return false;
            }
        }
        return false;
    }

    public int getRowCount() {
        return super.getRowCount();
    }

    public void removeReferences() {
        super.removeReferences();
        if (this.m_dataFieldNames != null) {
            this.m_dataFieldNames.removeAllElements();
            this.m_dataFieldNames = null;
        }
        if (this.m_dataFieldMode != null) {
            this.m_dataFieldMode.removeAllElements();
            this.m_dataFieldMode = null;
        }
    }
}

